###############################################################################
# PyMailCgi encodes the pop password whenever it is sent to/from client over
# the net with a user name, as hidden text fields or explicit url params; uses 
# encode/decode functions in this module to encrypt the pswd--upload your own
# version of this module to use a different encryption mechanism or key; pymail
# doesn't save the password on the server, and doesn't echo pswd as typed,
# but this isn't 100% safe--this module file itself might be vulnerable;
###############################################################################

import sys, time
dayofweek = time.localtime(time.time())[6]    # for custom schemes
forceReadablePassword = False
     
###############################################################################
# string encoding schemes
###############################################################################
     
if not forceReadablePassword:
    ###########################################################
    # don't do anything by default: the urllib.quote or
    # cgi.escape calls in commonhtml.py will escape the 
    # password as needed to embed in in URL or HTML; the 
    # cgi module undoes escapes automatically for us;
    ###########################################################
     
    def stringify(old):   return old
    def unstringify(old): return old
     
else:
    ###########################################################
    # convert encoded string to/from a string of digit chars,
    # to avoid problems with some special/nonprintable chars,
    # but still leave the result semi-readable (but encrypted);
    # some browsers had problems with escaped ampersands, etc.;
    ###########################################################
     
    separator = '-'
     
    def stringify(old):
        new = ''
        for char in old:
            ascii = str(ord(char)) 
            new   = new + separator + ascii       # '-ascii-ascii-ascii'
        return new
     
    def unstringify(old):
        new = ''
        for ascii in old.split(separator)[1:]:
            new = new + chr(int(ascii))
        return new 
     
###############################################################################
# encryption schemes: try PyCrypto, then rotor, then simple/custom scheme
###############################################################################

useCrypto = useRotor = True
try:
    import Crypto
except:
    useCrypto = False
    try:
        import rotor
    except:
        useRotor = False

if useCrypto:
    #######################################################
    # use third-party pycrypto package's AES algorithm
    # assumes pswd has no '\0' on the right: used to pad
    # change the private key here if you install this
    #######################################################

    sys.stderr.write('using PyCrypto\n')    
    from Crypto.Cipher import AES
    mykey = 'pymailcgi2'.ljust(16, '-')       # key must be 16, 24, or 32 bytes

    def do_encode(pswd):
        over = len(pswd) % 16
        if over: pswd += '\0' * (16-over)     # pad: len must be multiple of 16
        aesobj = AES.new(mykey, AES.MODE_ECB)
        return aesobj.encrypt(pswd)

    def do_decode(pswd):
        aesobj = AES.new(mykey, AES.MODE_ECB)
        pswd   = aesobj.decrypt(pswd)
        return pswd.rstrip('\0')

elif useRotor:
    #######################################################
    # use the standard lib's rotor module to encode pswd
    # this does a better job of encryption than code above
    # unfortunately, it is no longer available in Py 2.4
    #######################################################

    sys.stderr.write('using rotor\n')
    import rotor
    mykey = 'pymailcgi2'
     
    def do_encode(pswd):
        robj = rotor.newrotor(mykey)              # use enigma encryption
        return robj.encrypt(pswd)        
    
    def do_decode(pswd):
        robj = rotor.newrotor(mykey)
        return robj.decrypt(pswd)        

else:
    #######################################################
    # use our own custom scheme as a last resort
    # shuffle characters in some reversible fashion
    # caveat: very simple -- replace with one of your own
    #######################################################

    sys.stderr.write('using simple\n')
    adder = 1

    def do_encode(pswd):
        pswd = 'b' + pswd + '46'
        res = ''
        for char in pswd:
            res = res + chr(ord(char) + adder)    # inc each ascii code
        return str(res)
     
    def do_decode(pswd):
        pswd = pswd[1:-3]
        res = ''
        for char in pswd:
            res = res + chr(ord(char) - adder)
        return res
    
###############################################################################
# top-level entry points
###############################################################################
     
def encode(pswd):
    return stringify(do_encode(pswd))       # encrypt plus string encode
     
def decode(pswd):
    return do_decode(unstringify(pswd))
